/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.queue;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.base.VWConfigExposedFieldPanel;
import filenet.vw.toolkit.admin.property.base.VWConfigFilteredSecurityPanel;
import filenet.vw.toolkit.admin.property.base.VWConfigGeneralPane;
import filenet.vw.toolkit.admin.property.base.VWConfigIndexPane;
import filenet.vw.toolkit.admin.property.base.VWConfigOperationPane;
import filenet.vw.toolkit.admin.property.base.VWConfigSecurityPane;
import filenet.vw.toolkit.admin.property.base.VWConfigSystemFieldPanel;
import filenet.vw.toolkit.admin.property.queue.VWWorkBasketPanel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWConfigQueuePropertyDialog
extends VWModalDialog
implements ActionListener,
ChangeListener {
    private JTabbedPane m_tabbedPanel = null;
    private VWConfigGeneralPane m_generalPane = null;
    private VWConfigSystemFieldPanel m_sysExposedFieldsPane = null;
    private VWConfigExposedFieldPanel m_userExposedFieldsPane = null;
    private VWConfigIndexPane m_indexTablePane = null;
    private VWConfigSecurityPane m_securityPane = null;
    private VWConfigOperationPane m_operationPane = null;
    private VWWorkBasketPanel m_workBasketPanel = null;
    private JButton m_OKButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private Frame m_parentFrame = null;
    private VWQueueDefinition m_queueDefinition = null;
    private int m_nRetStatus = 1;
    private VWParticipant[] m_readSecurity = null;
    private VWParticipant[] m_writeSecurity = null;

    public VWConfigQueuePropertyDialog(Frame parent, VWSessionInfo sessionInfo, VWSystemConfiguration sysConfig, VWQueueDefinition queueDef, int nItemsInQueue) {
        super(parent);
        try {
            this.m_queueDefinition = queueDef;
            this.m_parentFrame = parent;
            this.setTitle(VWResource.QueueProperties);
            Dimension dim = VWStringUtils.stringToDimension("965,625");
            if (dim == null) {
                dim = new Dimension(650, 450);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            String queueType = null;
            switch (this.m_queueDefinition.getQueueType()) {
                case 1: {
                    queueType = VWResource.Work;
                    break;
                }
                case 2: {
                    queueType = VWResource.UserCentric;
                }
            }
            this.createControls(queueType, nItemsInQueue, sessionInfo, sysConfig);
            this.setLocationRelativeTo(parent);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getStatus() {
        return this.m_nRetStatus;
    }

    public boolean isModified() {
        return this.m_generalPane.isModified() || this.m_sysExposedFieldsPane.isModified() || this.m_userExposedFieldsPane.isModified() || this.m_indexTablePane.isModified() || this.m_securityPane.isModified() || this.m_operationPane.isModified() || this.m_workBasketPanel.isModified();
    }

    public void releaseResources() {
        if (this.m_tabbedPanel != null) {
            this.m_tabbedPanel.removeAll();
            this.m_tabbedPanel.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_tabbedPanel = null;
        }
        if (this.m_generalPane != null) {
            this.m_generalPane.releaseResources();
            this.m_generalPane.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_generalPane = null;
        }
        if (this.m_sysExposedFieldsPane != null) {
            this.m_sysExposedFieldsPane.releaseResources();
            this.m_sysExposedFieldsPane.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_sysExposedFieldsPane = null;
        }
        if (this.m_userExposedFieldsPane != null) {
            this.m_userExposedFieldsPane.releaseResources();
            this.m_userExposedFieldsPane.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_userExposedFieldsPane = null;
        }
        if (this.m_indexTablePane != null) {
            this.m_indexTablePane.releaseResources();
            this.m_indexTablePane.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_indexTablePane = null;
        }
        if (this.m_securityPane != null) {
            this.m_securityPane.releaseResources();
            this.m_securityPane.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_securityPane = null;
        }
        if (this.m_operationPane != null) {
            this.m_operationPane.releaseResources();
            this.m_operationPane.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_operationPane = null;
        }
        if (this.m_workBasketPanel != null) {
            this.m_workBasketPanel.releaseResources();
            this.m_workBasketPanel.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_workBasketPanel = null;
        }
        if (this.m_OKButton != null) {
            this.m_OKButton.removeActionListener(this);
            this.m_OKButton.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_OKButton.removeAll();
            this.m_OKButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.m_parentFrame = null;
        this.m_queueDefinition = null;
        if (this.m_readSecurity != null) {
            this.m_readSecurity = null;
        }
        if (this.m_writeSecurity != null) {
            this.m_writeSecurity = null;
        }
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_cancelButton) {
            this.m_nRetStatus = 1;
            this.setVisible(false);
        } else if (obj == this.m_OKButton) {
            try {
                this.stopEditing();
                this.m_queueDefinition.setDescription(this.m_generalPane.getDescription());
                if (this.m_securityPane.ValidateAccessList()) {
                    VWParticipant[] readSecList = this.m_securityPane.getReadSecurityPx();
                    VWParticipant[] writeSecList = this.m_securityPane.getWriteSecurityPx();
                    if (readSecList != null && readSecList.length > 0 && writeSecList != null && writeSecList.length > 0) {
                        int readSecCursor = 0;
                        for (int p = 0; p < writeSecList.length; ++p) {
                            boolean bFound = false;
                            String userNameP = writeSecList[p].getParticipantName();
                            for (int r = readSecCursor; r < readSecList.length; ++r) {
                                int cmpResult = userNameP.compareTo(readSecList[r].getParticipantName());
                                if (cmpResult != 0) continue;
                                bFound = true;
                                break;
                            }
                            if (bFound) continue;
                            VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.QueueSecurityError, 1);
                            return;
                        }
                    }
                    this.m_queueDefinition.setReadSecurityPx(readSecList);
                    this.m_queueDefinition.setWriteSecurityPx(writeSecList);
                    this.m_workBasketPanel.checkForErrors();
                    this.m_nRetStatus = 0;
                    this.setVisible(false);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
            }
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc066.htm");
        }
    }

    public void stateChanged(ChangeEvent event) {
        Object sourceObject = event.getSource();
        if (sourceObject.equals(this.m_tabbedPanel)) {
            this.stopEditing();
            Component aComponent = this.m_tabbedPanel.getSelectedComponent();
            if (aComponent == this.m_workBasketPanel) {
                this.m_workBasketPanel.setQueueDefinition(this.m_queueDefinition);
            }
        }
    }

    private void createControls(String queueType, int nItemsInQueue, VWSessionInfo sessionInfo, VWSystemConfiguration sysConfig) {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_tabbedPanel = new JTabbedPane();
            this.m_generalPane = new VWConfigGeneralPane(this.m_queueDefinition.getName(), VWResource.Queue, queueType, this.m_queueDefinition.getServerId(), this.m_queueDefinition.getDescription());
            this.m_generalPane.getAccessibleContext().setAccessibleParent(this.m_tabbedPanel);
            this.m_generalPane.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_tabbedPanel.add(VWResource.General, this.m_generalPane);
            this.m_sysExposedFieldsPane = new VWConfigSystemFieldPanel(this.m_parentFrame, sessionInfo.getSession(), this.m_queueDefinition);
            this.m_sysExposedFieldsPane.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_tabbedPanel.add(VWResource.SystemFields, this.m_sysExposedFieldsPane);
            this.m_userExposedFieldsPane = new VWConfigExposedFieldPanel(this.m_parentFrame, sysConfig, sessionInfo.getSession().getDatabaseType(), this.m_queueDefinition, nItemsInQueue);
            this.m_userExposedFieldsPane.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_tabbedPanel.add(VWResource.DataFields, this.m_userExposedFieldsPane);
            this.m_indexTablePane = new VWConfigIndexPane(this.m_parentFrame, this.m_queueDefinition);
            this.m_indexTablePane.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_tabbedPanel.add(VWResource.Indexes, this.m_indexTablePane);
            this.m_readSecurity = this.m_queueDefinition.getReadSecurityPx();
            this.m_writeSecurity = this.m_queueDefinition.getWriteSecurityPx();
            this.m_securityPane = sessionInfo.getSession().getSecurityDatabaseType() == 1 ? new VWConfigFilteredSecurityPanel(this, sessionInfo, this.m_readSecurity, this.m_writeSecurity, 1) : new VWConfigSecurityPane(this, sessionInfo, this.m_readSecurity, this.m_writeSecurity, 1);
            this.m_securityPane.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_tabbedPanel.add(VWResource.Security, this.m_securityPane);
            this.m_operationPane = new VWConfigOperationPane(this.m_queueDefinition, this);
            this.m_operationPane.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_tabbedPanel.add(VWResource.Operations, this.m_operationPane);
            this.m_workBasketPanel = new VWWorkBasketPanel(sessionInfo);
            this.m_workBasketPanel.setQueueDefinition(this.m_queueDefinition);
            this.m_workBasketPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_tabbedPanel.add(VWResource.Inbaskets, this.m_workBasketPanel);
            this.m_tabbedPanel.setSelectedIndex(0);
            this.m_tabbedPanel.addChangeListener(this);
            this.getContentPane().add((Component)this.m_tabbedPanel, "Center");
            this.m_tabbedPanel.getAccessibleContext().setAccessibleParent(this);
            this.m_tabbedPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            JPanel panel = this.createButtonPanel();
            this.getContentPane().add((Component)panel, "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new FlowLayout(1, 6, 6));
            this.m_OKButton = new JButton(VWResource.OK);
            this.m_OKButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_OKButton, buttonPanel, VWResource.OK, VWResource.OK);
            this.m_OKButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add(this.m_OKButton);
            this.m_cancelButton = new JButton(VWResource.Cancel);
            this.m_cancelButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, buttonPanel, VWResource.Cancel, VWResource.Cancel);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.Help);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, buttonPanel, VWResource.Help, VWResource.Help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add(this.m_helpButton);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void stopEditing() {
        this.m_sysExposedFieldsPane.stopEditing();
        this.m_userExposedFieldsPane.stopEditing();
        this.m_indexTablePane.stopEditing();
        this.m_operationPane.stopEditing();
        this.m_workBasketPanel.stopEditing();
    }
}

